%%Problema de los tres cuerpos%%

N1 = 1;         % El cuerpo central tiene una masa solar.
N2 = 3*(10^-6); % Masa del satelite en masas solares.
a=N2/N1;  

pL1=[1-((a/3)^(1/3)) 0];                            % Coordenadas del punto de lagrange 1.
pL2=[1+((a/3)^(1/3)) 0];                            % Coordenadas del punto de lagrange 2.
pL3=[-1-((5*a)/12) 0];                              % Coordenadas del punto de lagrange 3.
pL4=[(1/2)*((N1-N2)/(N1+N2)) sqrt(3)/2];            % Coordenadas del punto de lagrange 4.        

vL1=[0 29.78];                                                                                                  % Velocidad del satlite en PL1. 
vL2=vL1;                                                                                                        % Velocidad del satlite en PL2.
vL3=[0 -29.78];                                                                                                 % Velocidad del satlite en PL3.
vL4=[(29.78/(sqrt(3+((N1-N2)/(N1+N2))^2))*(-sqrt(3))) (29.78/(sqrt(3+((N1-N2)/(N1+N2))^2))*((N1-N2)/(N1+N2)))]; % Velocidad del satlite en PL4.

r0=[1 0];                   % El planeta est inicialmente a una U.A. de la estrella.
r3=pL1;                     % Posicin satelite (cambiar segn PL).
v0=[0 29.78];               % Velocidad inicial del planeta.
v3=vL1;                     % Velocidad inicial del satelite (cambiar segn PL).
s0 = [r0 v0 r3 v3];         % Vector con las condiciones iniciales.
xs=0;           % Posicin X de la estrella.
ys=0;           % Posicin Y de la estrella.

% Creo un vector de estructuras con los diferentes valores
% de los parmetros que controlan la precisin.
fun2 = @(t,s) Problema3C(t,s,N1,N2);
options = odeset('RelTol',1e-12,'AbsTol',1e-12);  % Fijamos la tolerancia del problema.

% Solucin usando ODE113
    tspan = 0:0.05:0.5; %Dibujamos solo media orbita para mejor visualizacin.
    [t solucion] =ode113(fun2,tspan,s0,options);
    xp=solucion(:,1);
    yp=solucion(:,2);
    vxp=solucion(:,3);
    vyp=solucion(:,4);
    xsat=solucion(:,5);
    ysat=solucion(:,6);
    vxsat=solucion(:,7);
    vysat=solucion(:,8); 
    
% Representamos las soluciones    
    figure(1)
    hold on
    plot(xs,ys,'ok','MarkerFaceColor','k');                         %Punto donde se encuentra la estrella.
    plot(r0(1),r0(2),'ok','MarkerFaceColor','c');                   %Posicin inicial del planeta.    
    plot(r3(1),r3(2),'ok','MarkerFaceColor','m');                   %Punto de Lagrange, posicin inicial del satlite.
    plot(xsat,ysat,'g+-');                                          %rbita del satlite.
    plot(xp,yp,'b*-');                                              %rbita del planeta.
    xlabel('x (U.A.)');
    ylabel('y (U.A.)');
    legend('Estrella','Pos.Inic. Planeta','P.L.(Pos.Inic. Satlite)','Orb.Satlite','Planeta','Location','SouthWest');
    titulo = 'rbita del planeta y del satlite';
    title(titulo);
    axis equal;
    hold off